<?php
/**
 * User Model
 * Represents a user entity in the system
 */
class User
{
    private $id;
    private $email;
    private $password;
    private $full_name;
    private $phone;
    private $role_id;
    private $status;
    private $email_verified_at;
    private $created_at;
    private $updated_at;
    
    // Relations
    private $role;
    private $permissions = [];

    public function __construct($data = [])
    {
        if (!empty($data)) {
            $this->fill($data);
        }
    }

    public function fill($data)
    {
        $this->id = $data['id'] ?? null;
        $this->email = $data['email'] ?? null;
        $this->password = $data['password'] ?? null;
        $this->full_name = $data['full_name'] ?? null;
        $this->phone = $data['phone'] ?? null;
        $this->role_id = $data['role_id'] ?? null;
        $this->status = $data['status'] ?? 'active';
        $this->email_verified_at = $data['email_verified_at'] ?? null;
        $this->created_at = $data['created_at'] ?? null;
        $this->updated_at = $data['updated_at'] ?? null;
    }

    // Getters
    public function getId() { return $this->id; }
    public function getEmail() { return $this->email; }
    public function getPassword() { return $this->password; }
    public function getFullName() { return $this->full_name; }
    public function getPhone() { return $this->phone; }
    public function getRoleId() { return $this->role_id; }
    public function getStatus() { return $this->status; }
    public function getEmailVerifiedAt() { return $this->email_verified_at; }
    public function getCreatedAt() { return $this->created_at; }
    public function getUpdatedAt() { return $this->updated_at; }
    public function getRole() { return $this->role; }
    public function getPermissions() { return $this->permissions; }

    // Setters
    public function setId($id) { $this->id = $id; }
    public function setEmail($email) { $this->email = $email; }
    public function setPassword($password) { $this->password = $password; }
    public function setFullName($full_name) { $this->full_name = $full_name; }
    public function setPhone($phone) { $this->phone = $phone; }
    public function setRoleId($role_id) { $this->role_id = $role_id; }
    public function setStatus($status) { $this->status = $status; }
    public function setEmailVerifiedAt($email_verified_at) { $this->email_verified_at = $email_verified_at; }
    public function setRole($role) { $this->role = $role; }
    public function setPermissions($permissions) { $this->permissions = $permissions; }

    public function toArray($includePassword = false)
    {
        $data = [
            'id' => $this->id,
            'email' => $this->email,
            'full_name' => $this->full_name,
            'phone' => $this->phone,
            'role_id' => $this->role_id,
            'status' => $this->status,
            'email_verified_at' => $this->email_verified_at,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];

        if ($includePassword) {
            $data['password'] = $this->password;
        }

        if ($this->role) {
            $data['role'] = $this->role;
        }

        if (!empty($this->permissions)) {
            $data['permissions'] = $this->permissions;
        }

        return $data;
    }

    public function hasPermission($permission)
    {
        return in_array($permission, $this->permissions);
    }

    public function isActive()
    {
        return $this->status === 'active';
    }
}
