<?php
/**
 * Payment Model
 * Represents a payment entity
 */
class Payment
{
    private $id;
    private $payment_code;
    private $invoice_id;
    private $gateway_id;
    private $channel_id;
    private $amount;
    private $admin_fee;
    private $total_amount;
    private $status;
    private $payment_url;
    private $external_id;
    private $paid_at;
    private $expired_at;
    private $created_at;
    private $updated_at;
    
    // Relations
    private $invoice;
    private $gateway;

    public function __construct($data = [])
    {
        if (!empty($data)) {
            $this->fill($data);
        }
    }

    public function fill($data)
    {
        $this->id = $data['id'] ?? null;
        $this->payment_code = $data['payment_code'] ?? null;
        $this->invoice_id = $data['invoice_id'] ?? null;
        $this->gateway_id = $data['gateway_id'] ?? null;
        $this->channel_id = $data['channel_id'] ?? null;
        $this->amount = $data['amount'] ?? 0;
        $this->admin_fee = $data['admin_fee'] ?? 0;
        $this->total_amount = $data['total_amount'] ?? 0;
        $this->status = $data['status'] ?? 'pending';
        $this->payment_url = $data['payment_url'] ?? null;
        $this->external_id = $data['external_id'] ?? null;
        $this->paid_at = $data['paid_at'] ?? null;
        $this->expired_at = $data['expired_at'] ?? null;
        $this->created_at = $data['created_at'] ?? null;
        $this->updated_at = $data['updated_at'] ?? null;
    }

    // Getters
    public function getId() { return $this->id; }
    public function getPaymentCode() { return $this->payment_code; }
    public function getInvoiceId() { return $this->invoice_id; }
    public function getGatewayId() { return $this->gateway_id; }
    public function getChannelId() { return $this->channel_id; }
    public function getAmount() { return $this->amount; }
    public function getAdminFee() { return $this->admin_fee; }
    public function getTotalAmount() { return $this->total_amount; }
    public function getStatus() { return $this->status; }
    public function getPaymentUrl() { return $this->payment_url; }
    public function getExternalId() { return $this->external_id; }
    public function getPaidAt() { return $this->paid_at; }
    public function getExpiredAt() { return $this->expired_at; }
    public function getCreatedAt() { return $this->created_at; }
    public function getUpdatedAt() { return $this->updated_at; }
    public function getInvoice() { return $this->invoice; }
    public function getGateway() { return $this->gateway; }

    // Setters
    public function setId($id) { $this->id = $id; }
    public function setPaymentCode($payment_code) { $this->payment_code = $payment_code; }
    public function setInvoiceId($invoice_id) { $this->invoice_id = $invoice_id; }
    public function setGatewayId($gateway_id) { $this->gateway_id = $gateway_id; }
    public function setChannelId($channel_id) { $this->channel_id = $channel_id; }
    public function setAmount($amount) { $this->amount = $amount; }
    public function setAdminFee($admin_fee) { $this->admin_fee = $admin_fee; }
    public function setTotalAmount($total_amount) { $this->total_amount = $total_amount; }
    public function setStatus($status) { $this->status = $status; }
    public function setPaymentUrl($payment_url) { $this->payment_url = $payment_url; }
    public function setExternalId($external_id) { $this->external_id = $external_id; }
    public function setPaidAt($paid_at) { $this->paid_at = $paid_at; }
    public function setExpiredAt($expired_at) { $this->expired_at = $expired_at; }
    public function setInvoice($invoice) { $this->invoice = $invoice; }
    public function setGateway($gateway) { $this->gateway = $gateway; }

    public function toArray()
    {
        $data = [
            'id' => $this->id,
            'payment_code' => $this->payment_code,
            'invoice_id' => $this->invoice_id,
            'gateway_id' => $this->gateway_id,
            'channel_id' => $this->channel_id,
            'amount' => $this->amount,
            'admin_fee' => $this->admin_fee,
            'total_amount' => $this->total_amount,
            'status' => $this->status,
            'payment_url' => $this->payment_url,
            'external_id' => $this->external_id,
            'paid_at' => $this->paid_at,
            'expired_at' => $this->expired_at,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];

        if ($this->invoice) {
            $data['invoice'] = is_object($this->invoice) ? $this->invoice->toArray() : $this->invoice;
        }

        if ($this->gateway) {
            $data['gateway'] = $this->gateway;
        }

        return $data;
    }

    public function isPaid()
    {
        return $this->status === 'paid';
    }

    public function isExpired()
    {
        return $this->expired_at && strtotime($this->expired_at) < time();
    }
}
