<?php
/**
 * Invoice Model
 * Represents an invoice entity
 */
class Invoice
{
    private $id;
    private $invoice_number;
    private $customer_id;
    private $billing_cycle_id;
    private $issue_date;
    private $due_date;
    private $subtotal;
    private $discount_amount;
    private $tax_amount;
    private $total_amount;
    private $status;
    private $paid_at;
    private $created_at;
    private $updated_at;
    
    // Relations
    private $customer;
    private $items = [];
    private $payments = [];

    public function __construct($data = [])
    {
        if (!empty($data)) {
            $this->fill($data);
        }
    }

    public function fill($data)
    {
        $this->id = $data['id'] ?? null;
        $this->invoice_number = $data['invoice_number'] ?? null;
        $this->customer_id = $data['customer_id'] ?? null;
        $this->billing_cycle_id = $data['billing_cycle_id'] ?? null;
        $this->issue_date = $data['issue_date'] ?? null;
        $this->due_date = $data['due_date'] ?? null;
        $this->subtotal = $data['subtotal'] ?? 0;
        $this->discount_amount = $data['discount_amount'] ?? 0;
        $this->tax_amount = $data['tax_amount'] ?? 0;
        $this->total_amount = $data['total_amount'] ?? 0;
        $this->status = $data['status'] ?? 'pending';
        $this->paid_at = $data['paid_at'] ?? null;
        $this->created_at = $data['created_at'] ?? null;
        $this->updated_at = $data['updated_at'] ?? null;
    }

    // Getters
    public function getId() { return $this->id; }
    public function getInvoiceNumber() { return $this->invoice_number; }
    public function getCustomerId() { return $this->customer_id; }
    public function getBillingCycleId() { return $this->billing_cycle_id; }
    public function getIssueDate() { return $this->issue_date; }
    public function getDueDate() { return $this->due_date; }
    public function getSubtotal() { return $this->subtotal; }
    public function getDiscountAmount() { return $this->discount_amount; }
    public function getTaxAmount() { return $this->tax_amount; }
    public function getTotalAmount() { return $this->total_amount; }
    public function getStatus() { return $this->status; }
    public function getPaidAt() { return $this->paid_at; }
    public function getCreatedAt() { return $this->created_at; }
    public function getUpdatedAt() { return $this->updated_at; }
    public function getCustomer() { return $this->customer; }
    public function getItems() { return $this->items; }
    public function getPayments() { return $this->payments; }

    // Setters
    public function setId($id) { $this->id = $id; }
    public function setInvoiceNumber($invoice_number) { $this->invoice_number = $invoice_number; }
    public function setCustomerId($customer_id) { $this->customer_id = $customer_id; }
    public function setBillingCycleId($billing_cycle_id) { $this->billing_cycle_id = $billing_cycle_id; }
    public function setIssueDate($issue_date) { $this->issue_date = $issue_date; }
    public function setDueDate($due_date) { $this->due_date = $due_date; }
    public function setSubtotal($subtotal) { $this->subtotal = $subtotal; }
    public function setDiscountAmount($discount_amount) { $this->discount_amount = $discount_amount; }
    public function setTaxAmount($tax_amount) { $this->tax_amount = $tax_amount; }
    public function setTotalAmount($total_amount) { $this->total_amount = $total_amount; }
    public function setStatus($status) { $this->status = $status; }
    public function setPaidAt($paid_at) { $this->paid_at = $paid_at; }
    public function setCustomer($customer) { $this->customer = $customer; }
    public function setItems($items) { $this->items = $items; }
    public function setPayments($payments) { $this->payments = $payments; }

    public function toArray()
    {
        $data = [
            'id' => $this->id,
            'invoice_number' => $this->invoice_number,
            'customer_id' => $this->customer_id,
            'billing_cycle_id' => $this->billing_cycle_id,
            'issue_date' => $this->issue_date,
            'due_date' => $this->due_date,
            'subtotal' => $this->subtotal,
            'discount_amount' => $this->discount_amount,
            'tax_amount' => $this->tax_amount,
            'total_amount' => $this->total_amount,
            'status' => $this->status,
            'paid_at' => $this->paid_at,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];

        if ($this->customer) {
            $data['customer'] = is_object($this->customer) ? $this->customer->toArray() : $this->customer;
        }

        if (!empty($this->items)) {
            $data['items'] = $this->items;
        }

        if (!empty($this->payments)) {
            $data['payments'] = $this->payments;
        }

        return $data;
    }

    public function isPaid()
    {
        return $this->status === 'paid';
    }

    public function isOverdue()
    {
        return $this->status === 'overdue' || 
               ($this->status === 'pending' && strtotime($this->due_date) < time());
    }
}
