<?php
/**
 * Customer Model
 * Represents a customer entity
 */
class Customer
{
    private $id;
    private $user_id;
    private $customer_code;
    private $full_name;
    private $phone;
    private $address;
    private $city;
    private $province;
    private $postal_code;
    private $latitude;
    private $longitude;
    private $status;
    private $created_at;
    private $updated_at;

    public function __construct($data = [])
    {
        if (!empty($data)) {
            $this->fill($data);
        }
    }

    public function fill($data)
    {
        $this->id = $data['id'] ?? null;
        $this->user_id = $data['user_id'] ?? null;
        $this->customer_code = $data['customer_code'] ?? null;
        $this->full_name = $data['full_name'] ?? null;
        $this->phone = $data['phone'] ?? null;
        $this->address = $data['address'] ?? null;
        $this->city = $data['city'] ?? null;
        $this->province = $data['province'] ?? null;
        $this->postal_code = $data['postal_code'] ?? null;
        $this->latitude = $data['latitude'] ?? null;
        $this->longitude = $data['longitude'] ?? null;
        $this->status = $data['status'] ?? 'active';
        $this->created_at = $data['created_at'] ?? null;
        $this->updated_at = $data['updated_at'] ?? null;
    }

    // Getters
    public function getId() { return $this->id; }
    public function getUserId() { return $this->user_id; }
    public function getCustomerCode() { return $this->customer_code; }
    public function getFullName() { return $this->full_name; }
    public function getPhone() { return $this->phone; }
    public function getAddress() { return $this->address; }
    public function getCity() { return $this->city; }
    public function getProvince() { return $this->province; }
    public function getPostalCode() { return $this->postal_code; }
    public function getLatitude() { return $this->latitude; }
    public function getLongitude() { return $this->longitude; }
    public function getStatus() { return $this->status; }
    public function getCreatedAt() { return $this->created_at; }
    public function getUpdatedAt() { return $this->updated_at; }

    // Setters
    public function setId($id) { $this->id = $id; }
    public function setUserId($user_id) { $this->user_id = $user_id; }
    public function setCustomerCode($customer_code) { $this->customer_code = $customer_code; }
    public function setFullName($full_name) { $this->full_name = $full_name; }
    public function setPhone($phone) { $this->phone = $phone; }
    public function setAddress($address) { $this->address = $address; }
    public function setCity($city) { $this->city = $city; }
    public function setProvince($province) { $this->province = $province; }
    public function setPostalCode($postal_code) { $this->postal_code = $postal_code; }
    public function setLatitude($latitude) { $this->latitude = $latitude; }
    public function setLongitude($longitude) { $this->longitude = $longitude; }
    public function setStatus($status) { $this->status = $status; }

    public function toArray()
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'customer_code' => $this->customer_code,
            'full_name' => $this->full_name,
            'phone' => $this->phone,
            'address' => $this->address,
            'city' => $this->city,
            'province' => $this->province,
            'postal_code' => $this->postal_code,
            'latitude' => $this->latitude,
            'longitude' => $this->longitude,
            'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }

    public function isActive()
    {
        return $this->status === 'active';
    }
}
