<?php
/**
 * Webhook Controller
 * Handles payment gateway webhooks
 */
class WebhookController
{
    private $paymentGatewayService;
    private $request;
    private $logger;

    public function __construct()
    {
        $this->paymentGatewayService = new PaymentGatewayService();
        $this->request = new Request();
        $this->logger = Logger::getInstance();
    }

    /**
     * Handle Xendit webhook
     * POST /api/webhooks/xendit
     */
    public function xendit()
    {
        try {
            $payload = $this->request->getBody();
            $signature = $this->request->getHeader('x-callback-token');

            $this->logger->info('Xendit webhook received', [
                'payload' => $payload
            ]);

            // Get Xendit gateway ID
            $db = Database::getInstance();
            $query = "SELECT id FROM payment_gateways WHERE code = 'XENDIT' LIMIT 1";
            $result = $db->query($query);
            
            if (empty($result)) {
                return Response::notFound('Gateway not found');
            }

            $gatewayId = $result[0]['id'];

            // Process webhook
            $this->paymentGatewayService->processWebhook($gatewayId, $payload, $signature);

            return Response::success(null, 'Webhook processed successfully');

        } catch (PaymentException $e) {
            $this->logger->error('Xendit webhook error', ['error' => $e->getMessage()]);
            return Response::badRequest($e->getMessage());
        } catch (Exception $e) {
            $this->logger->error('Xendit webhook processing failed', [
                'error' => $e->getMessage()
            ]);
            return Response::serverError('Webhook processing failed');
        }
    }

    /**
     * Handle Tripay webhook
     * POST /api/webhooks/tripay
     */
    public function tripay()
    {
        try {
            $payload = $this->request->getBody();
            $signature = $this->request->getHeader('X-Signature');

            $this->logger->info('Tripay webhook received', [
                'payload' => $payload
            ]);

            // Get Tripay gateway ID
            $db = Database::getInstance();
            $query = "SELECT id FROM payment_gateways WHERE code = 'TRIPAY' LIMIT 1";
            $result = $db->query($query);
            
            if (empty($result)) {
                return Response::notFound('Gateway not found');
            }

            $gatewayId = $result[0]['id'];

            // Process webhook
            $this->paymentGatewayService->processWebhook($gatewayId, $payload, $signature);

            return Response::success(null, 'Webhook processed successfully');

        } catch (PaymentException $e) {
            $this->logger->error('Tripay webhook error', ['error' => $e->getMessage()]);
            return Response::badRequest($e->getMessage());
        } catch (Exception $e) {
            $this->logger->error('Tripay webhook processing failed', [
                'error' => $e->getMessage()
            ]);
            return Response::serverError('Webhook processing failed');
        }
    }
}
